<?php
/**
 * The Template for displaying all single posts.
 *
 * @package _tk
 */

get_header(); ?>



<div class="single-team">
	<div class="container">		
		<div class="breadcrumbs-box wow fadeInRight">
			<p id="breadcrumbs"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"><img src="<?php echo get_template_directory_uri(); ?>/includes/img/home.svg"></a> / <a href="/o-firmie">O firmie</a> / <a href="/o-firmie/">O firmie</a> / <?php the_title(); ?></p>
		</div>
		
		<div class="people-box row">
			<div class="col-sm-16 col-sm-offset-4 people">
				<div class="item row">
					<?php if (has_post_thumbnail()) { ?>
						<div class="col-sm-8 people-image omega hidden-xs">
							<div class="people-image-content">
								<?php the_post_thumbnail(); ?>
							</div>
						</div>
						<div class="col-sm-16 people-text-box alpha">
					<?php } else { ?>
						<div class="col-sm-24">
					<?php } ?>
							<div class="people-text">
								<div class="people-text-container">
									<h3><?php the_title(); ?></h3>
									<?php if (get_field('position')) { ?>
										<p class="position"><?php the_field('position'); ?></p>
									<?php } ?>
									<?php if (get_field('phone') or get_field('email')) { ?>
										<p class="people-contact">
											<?php if (get_field('phone')) { ?>
												<a href="tel:<?php get_field('phone'); ?>"><i class="fa fa-phone" aria-hidden="true"></i> <?php the_field('phone'); ?></a>
											<?php } ?>
											<?php if (get_field('email')) { ?>
												<a href="mailto:<?php the_field('email'); ?>"><i class="fa fa-envelope" aria-hidden="true"></i> <?php the_field('email'); ?></a>
											<?php } ?>
										</p>
									<?php } ?>
								</div>
							</div>
						</div>
				</div>
				
			</div>
		</div>
	
		<div class="row marginbottom">
			<div class="col-sm-16 col-sm-offset-4">
				<?php the_content(); ?>
				<div class="arrow-nav text-center">
					<?php function custom_post_order($sql) {
						if ( !is_main_query() || !is_singular() )
							return $sql;
						if (is_singular('team')) {
							$the_post = get_post( get_the_ID() );
							$patterns = array();
							$patterns[] = '/post_date/';
							$patterns[] = '/\'[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}\'/';
							$replacements = array();
							$replacements[] = 'menu_order';
							$replacements[] = $the_post->menu_order;
							return preg_replace( $patterns, $replacements, $sql );
						}
					}
					add_filter( 'get_next_post_where', 'custom_post_order' );
					add_filter( 'get_previous_post_where', 'custom_post_order' );
					function custom_post_order_sort($sql) {
						if ( !is_main_query() || !is_singular() )
							return $sql;
						if (is_singular('team')) {
							$pattern = '/post_date/';
							$replacement = 'menu_order';
							return preg_replace( $pattern, $replacement, $sql );
						}
					}
					add_filter( 'get_next_post_sort', 'custom_post_order_sort' );
					add_filter( 'get_previous_post_sort', 'custom_post_order_sort' ); ?>
					<?php previous_post_link( '%link', '', true, '', 'team_category') ?>
					<?php next_post_link( '%link', '', true, '', 'team_category') ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php get_footer(); ?>